"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DefaultContextMenu_exports = {};
__export(DefaultContextMenu_exports, {
  DefaultContextMenu: () => DefaultContextMenu
});
module.exports = __toCommonJS(DefaultContextMenu_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var _ContextMenu = __toESM(require("@radix-ui/react-context-menu"));
var import_editor = require("@tldraw/editor");
var import_react = require("react");
var import_useMenuIsOpen = require("../../hooks/useMenuIsOpen");
var import_TldrawUiMenuContext = require("../primitives/menus/TldrawUiMenuContext");
var import_DefaultContextMenuContent = require("./DefaultContextMenuContent");
const DefaultContextMenu = (0, import_react.memo)(function DefaultContextMenu2({
  children
}) {
  const editor = (0, import_editor.useEditor)();
  const { Canvas } = (0, import_editor.useEditorComponents)();
  const cb = (0, import_react.useCallback)(
    (isOpen2) => {
      if (!isOpen2) {
        const onlySelectedShape = editor.getOnlySelectedShape();
        if (onlySelectedShape && editor.isShapeOrAncestorLocked(onlySelectedShape)) {
          editor.setSelectedShapes([]);
        }
      } else {
        if (editor.getInstanceState().isCoarsePointer) {
          const selectedShapes = editor.getSelectedShapes();
          const {
            inputs: { currentPagePoint }
          } = editor;
          const shapesAtPoint = editor.getShapesAtPoint(currentPagePoint);
          if (
            // if there are no selected shapes
            !editor.getSelectedShapes().length || // OR if none of the shapes at the point include the selected shape
            !shapesAtPoint.some((s) => selectedShapes.includes(s))
          ) {
            const lockedShapes = shapesAtPoint.filter((s) => editor.isShapeOrAncestorLocked(s));
            if (lockedShapes.length) {
              editor.select(...lockedShapes.map((s) => s.id));
            }
          }
        }
      }
    },
    [editor]
  );
  const container = (0, import_editor.useContainer)();
  const [isOpen, handleOpenChange] = (0, import_useMenuIsOpen.useMenuIsOpen)("context menu", cb);
  const content = children ?? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_DefaultContextMenuContent.DefaultContextMenuContent, {});
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(_ContextMenu.Root, { dir: "ltr", onOpenChange: handleOpenChange, modal: false, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(_ContextMenu.Trigger, { onContextMenu: void 0, dir: "ltr", children: Canvas ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Canvas, {}) : null }),
    isOpen && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(_ContextMenu.Portal, { container, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      _ContextMenu.Content,
      {
        className: "tlui-menu scrollable",
        "data-testid": "context-menu",
        alignOffset: -4,
        collisionPadding: 4,
        onContextMenu: import_editor.preventDefault,
        children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_TldrawUiMenuContext.TldrawUiMenuContextProvider, { type: "context-menu", sourceId: "context-menu", children: content })
      }
    ) })
  ] });
});
//# sourceMappingURL=DefaultContextMenu.js.map
